---
generated_at: 2026-02-01 10:30:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：17-INTERFACE イベント

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `sys/dev/usb/usb_device.c` 2747-2791行目 - INTERFACEループの実装
- E-02: `sys/dev/usb/usb_device.c` 2789行目 - devctl_notify("USB", "INTERFACE", type, ...)
- E-03: `sys/dev/usb/usb_device.c` 2748行目 - usbd_get_iface()呼び出し
- E-04: `sys/dev/usb/usb_device.c` 2749-2752行目 - NULL/idescチェック
- E-05: `sys/dev/usb/usb_device.c` 2755-2787行目 - sbuf_printfによるデータ生成
- E-06: `sys/dev/usb/usb_device.c` 2783行目 - bInterfaceNumber参照
- E-07: `sys/dev/usb/usb_device.c` 2784行目 - bNumEndpoints参照
- E-08: `sys/dev/usb/usb_device.c` 2785-2787行目 - クラス/サブクラス/プロトコル参照

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | devctl_notify("USB", "INTERFACE", type, sbuf_data)として通知される | E-02 | ○ |
| C-02 | 各インターフェースごとに個別に通知が発行される | E-01 | ○ |
| C-03 | iface == NULLでループ終了 | E-04 | ○ |
| C-04 | iface->idesc == NULLでスキップ | E-04 | ○ |
| C-05 | インターフェース番号が含まれる | E-06 | ○ |
| C-06 | エンドポイント数が含まれる | E-07 | ○ |
| C-07 | インターフェースクラス/サブクラス/プロトコルが含まれる | E-08 | ○ |
| C-08 | DEVICE通知の後に連続して発行される | E-01 | ○ |
| C-09 | USB_IFACE_MAXまでスキャンされる | E-01 | ○ |
| C-10 | devctl_notifyは2789行目で呼び出される | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張にソースコードからの直接的な根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] devctl_notify()の引数がコードと一致しているか確認
- [ ] インターフェースディスクリプタのフィールドが正確に記述されているか確認
